//=============================================================================
// LastMapXYandIdMemory.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 最終座標記録機構
 * @target MZ
 * @author くろあめ
 *
 * @param LastMapX-Memo
 * @text 最終マップX座標格納変数ID
 * @desc 最後に移動したマップのX座標を格納する変数のIDを指定します。
 * @default 1
 * @type number
 *
 * @param LastMapY-Memo
 * @text 最終マップY座標格納変数ID
 * @desc 最後に移動したマップのX座標を格納する変数のIDを指定します。
 * @default 2
 * @type number
 *
 * @param LastCharDirection-Memo
 * @text 最終マップ移動時向き格納変数ID
 * @desc 最後に移動した際のプレイヤーの向きを格納する変数のIDを指定します。
 * @default 3
 * @type number
 *
 * @param LastMapID-Memo
 * @text 最終マップID座標格納変数ID
 * @desc 最後に移動したマップのIDを格納する変数のIDを指定します。
 * @default 4
 * @type number
 *
 * @param LastMapID-NoMemoryFlg
 * @text 最終マップ座標格納格納禁止スイッチID
 * @desc このスイッチがONのとき、最終座標の記録は行われません
 * @default 1
 * @type number
 *
 * @help
 * 最後に場所移動したマップのIDと、初期のXY座標を
 * それぞれ指定した変数に格納します。
 *
 * これだけでは特に意味を成さないプラグインです
 * 格納した座標とマップIDを、あとからイベントコマンドなどの
 * 各種処理で利用するための土台です。
 * 
 * マップの名称に [LPNM] と記載することで
 * 該当のマップに場所移動した際には、IDと座標の格納を行いません
 * イベントシーン専用マップなどのIDと座標の記録を防止することなど
 * 各種制御に利用できます。
 *
 * このプラグインは「場所移動」のイベントコマンドで呼び出される関数を
 * 再定義する都合上、競合性が高いものとなっています
 * 導入する際には極力上の方に配置することをお勧めします。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

const parameters            = PluginManager.parameters('LastMapXYandIdMemory');
const LastMapXMemo          = Number(parameters['LastMapX-Memo']);
const LastMapYMemo          = Number(parameters['LastMapY-Memo']);
const LastCharDirectionMemo = Number(parameters['LastCharDirection-Memo']);
const LastMapIDMemo         = Number(parameters['LastMapID-Memo']);
const LastMapIDNoMemoryFlg  = Number(parameters['LastMapID-NoMemoryFlg']);

//const _Game_Interpreter_command201_bk = Game_Interpreter.prototype.command201;
// Transfer Player

Game_Interpreter.prototype.command201 = function(params) {
    if ($gameParty.inBattle() || $gameMessage.isBusy()) {
        return false;
    }
    let mapId, x, y;
    if (params[0] === 0) {
        // Direct designation
        mapId = params[1];
        x = params[2];
        y = params[3];
    } else {
        // Designation with variables
        mapId = $gameVariables.value(params[1]);
        x = $gameVariables.value(params[2]);
        y = $gameVariables.value(params[3]);
    }
    $gamePlayer.reserveTransfer(mapId, x, y, params[4], params[5]);
    
    this.setWaitMode("transfer");
    
    // ここから追加処理
    
    NoMemory1 = ($dataMapInfos[mapId].name.indexOf('[LPNM]') !== -1) ? 1 : 0;
    NoMemory2 = $gameSwitches.value(LastMapIDNoMemoryFlg);
    if( NoMemory1 == 0 && NoMemory2 == 0 ){
      $gameVariables.setValue(LastMapIDMemo, mapId); 
      $gameVariables.setValue(LastMapXMemo, x);
      $gameVariables.setValue(LastMapYMemo, y);
      let setDirection = 2;
      if(params[4] == 0){
        setDirection = $gamePlayer.direction();
      }
      $gameVariables.setValue(LastCharDirectionMemo, setDirection); 
    }
    // ここまで追加処理
    
    return true;
};

})();